"""util:
miscellaneous co2 utilities
"""

from StringIO import StringIO
from traceback import print_exc
from os.path import join, isfile
from os import remove as os_remove

try:
	from xml.marshal import generic as maresciallo
	can_marshal = True
except:
	can_marshal = False

##class DumpError(Exception): pass

#print_trace = True

def trace(print_it=False):
	"""
	trace():
	return or print (depending on module variable print_trace) a traceback
	after an exception occurred.
	"""
	tb_string = StringIO()
	print_exc(file = tb_string)
	value = tb_string.getvalue()
	tb_string.close()
	if not print_it:
		return value
	limiter = 64 * '#'
	print '%s\n%s\n%s' % (limiter,
												value.replace('\n', '\n* '),
												limiter)

def dump_sat_data(sat_data, path, filename):
	"""dump_sat_data(sat_data, path, filename):
	convert data to xml and write it to a file. used by the relay to serialize
	satellite data.
	sat_data: simple python object to be serialized;
	path: path of the dump file (directory containing the file, absolute path);
	filename: name of the dumpfile.
	"""
	f = None
	try:
		f = file(join(path, filename), 'w')
		maresciallo.dump(sat_data, f)
	finally:
		if f is not None: f.close()

def read_sat_data(path, filename):
	"""read_sat_datapath, filename):
	load an xml dumpfile (as created by dump_sat_data), and convert the data
	to a python object.
	path: path of the dump file (directory containing the file, absolute path);
	filename: name of the dumpfile.
	returns a python object.
	"""
	f = None
	try:
		dump_file_name = join(path, filename)
		if not isfile(dump_file_name):
			return []
		f = file(dump_file_name, 'r')
		return maresciallo.load(f)
	finally:
		if f is not None: f.close()

def remove_file(path, filename):
	"""remove_file(path, filename):
	remove a file.
	path: path to the file (directory containing the file, absolute path);
	file: name of the file do be removed.
	returns boolean, True on success, False on failure.
	"""
	fn = join(path, filename)
	if isfile(fn):
		os_remove(fn)
		return True
	return False


# unused

##def make_url(address):
##	return 'http://%s:%d' % (address)

##def get_dict_values(dict, *keys):
##	"""
##	get_dict_values(dict, *keys) -> value list
##	get a list of values from a dictionary.
##	dict: dictionary to scan
##	keys: key names to look up
##	dict is scanned for keys. the returned list contains their associated values.
##	value order is the same as keys order. multiple occurances of keys is allowed,
##	KeyErrors (specified key not in dict) are silently ignored.
##	DECPRECATED
##	"""
##	values = []
##	for key in keys:
##		try: values.append(dict[key])
##		except KeyError: pass
##	return values

