"""satellite:
the co2 registry with satellite functionality
"""

from xmlrpclib import Fault
from threading import Thread

import registry
#from limiter import Limiter

class Co2SatelliteRegistry(registry.Co2Registry):
	"""Co2SatelliteRegistry: provides the satellite specific methods.
	"""
	def __init__(self, vars):
		"""__init__(vars):
		first calls Co2Registry's __init__, then does some initial stuff for
		its own (register with the relay).
		vars: dictionary, registry specific variables.
		"""
		registry.Co2Registry.__init__(self, vars)
		# TODO: sollte nicht eher von aussen registriert/subscribed werden (co2.py)?
		self.host_id = self._register()
		self.debug(self, 'registered as %s' % self.host_id, 2)
		#self.limiter = Limiter()
		self.limiter.init(self._relay_real, self.debug)
		self.limiter.start()

	def _register(self):
		"""_register():
		make a register call to the relay. returns a new host_id.
		"""
		# exception handling is done in registry.Co2Registry
		#return self._call_relay('relay.register', {'sat_address':self.vars['addr']})
		plugin_list = self.vars['plugin_list'] or []
		return self._call_relay_thread('relay.register', {'port':self.vars['addr'][1],
																											'plugins':plugin_list or [],
																											'nick':self.vars['nick']})

	def _exit_hook(self):
		"""_exit_hook():
		clean up method, called by server on exit.
		"""
		# call registry's exit hook
		registry.Co2Registry._exit_hook(self)
		#self.limiter.halt()
		self.debug(self, 'deregistering...', 1)
		# deregister with the relay
		self.debug(self, self._call_relay('relay.deregister'), 0)
		self.debug(self, 'finished cleaning up.', 1)

	def _relay(self, data_dict):
		self.limiter.enqueue(data_dict)

	def _relay_real(self, data_dict):
		"""relay(data_dict):
		convenience method on top of _call_relay(). equivalent to
		_call_relay('relay.relay', data_dict).
		data_dict: dictionary, data to be relayed.
		"""
		#return self._call_relay('relay.relay', data_dict)
		if not data_dict.has_key('data'):
			raise Co2RegistryError('no key "data" found. nothing to send...')
		return self._call_relay('relay.relay', data_dict)

	def _call_relay(self, method_name, param_dict={}):
		"""_call_relay(method_name[, param_dict]):
		start a thread that calls method_name with argument param_dict on the relay .
		method_name: name of the method to be called;
		param_dict: optional parameter dictionary, default: {}.
		"""
		Thread(target = self._call_relay_thread, args = (method_name, param_dict)).start()
		return 'OK'

	def _call_relay_thread(self, method_name, param_dict):
		"""_call_relay_thread(method_name, param_dict):
		outgoing call to the relay. exceptions are cought and not passed on to the
		calling host, except when method_name is 'relay.register' a Co2RegistryError
		is raised, so that satellites can react, probably exit.
		method_name: name of the relay's method to be called;
		param_dict: dictionary, argument to the method.
		"""
		#print 'REGISTRY _call_relay RAW:', method_name, param_dict
		param_dict['host_id'] = self.host_id# or 'unregistered@%s:%d' % self.vars['addr']
		#print 'REGISTRY _call_relay +ID:', method_name, param_dict
		try:
			self.debug(self,
								 'calling relay ["%s%s"]' % (method_name, str(param_dict)),
								 0)
			return getattr(self.relay_proxy.proxy, method_name)(param_dict)
		except Exception, msg:
			param_dict.pop('host_id')
			self.debug(self,
								 'call "%s(%s)" failed: %s' % (method_name,
																							 str(param_dict),
																							 msg),
								 3)
			if method_name == 'relay.register':
				self.debug(self, msg, 3)
				raise registry.Co2RegistryError('ERROR: unable to register. relay unreachable?')

##	def _relay(self, data_dict):
##		try:
##			return self._call_relay('relay.relay', data_dict)
##		except Exception, msg:
##			self.debug(self, 'WARNING: data "%s" was NOT relayed [%s]' % (str(data_dict), msg))

##	def _call_relay(self, method_name, param_dict={}):
##		"""_call_relay(method_name, param_dict) -> reply
##		outgoing call to the relay.
##		method_name: name of the relay's method to be called.
##		param_dict: parameter dictionary.
##		"""
##		#print 'REGISTRY _call_relay RAW:', method_name, param_dict
##		param_dict['host_id'] = self.host_id
##		#print 'REGISTRY _call_relay +ID:', method_name, param_dict
##		return getattr(self.proxy.proxy, method_name)(param_dict)
