"""interact.py
a very stupid shell-interactive interface.
all you type at the prompt is sent to the relay.
incomming messages are displayed.

if you run this, be sure to set background to False in the global
config file, otherwise you won't get the prompt!

stupid, because:
the prompt and incomming messages are displayed among logging
and debugging information.

all prompt input is sent as a string.

to quit the satellite, first type 'q' or 'quit' (without the quotes)
then type control-c.
"""

from threading import Thread

import plugin

class X_Interact(plugin.Co2Plugin):
	def __init__(self, var_dict):
		plugin.Co2Plugin.__init__(self, var_dict)
		self.prompt()

	def receive(self, data_dict):
		print 'IN: %s\nOUT: ' % str(data_dict['data'])

	def prompt(self):
		Thread(target = self.prompt_thread, args = ()).start()

	def prompt_thread(self):
		data = ''
		while True:
			data = raw_input('OUT [q or quit to exit]: ')
			if data in ['q', 'quit']:
				print 'now control-c!'
				break
			self.send(str(data))
