"""co2 plugin base module.
"""

class Co2Plugin:
	"""base class for co2 plugins."""
	def __init__(self, var_dict):
		"""__init__(var_dict):
		var_dict: dictionary passed on from loader.py, contains:
		'relay_method': method to use for relaying (plugin to co2);
		'debug_method': method to use for debugging;
		'log_method': method to use for logging;
		'dotted_name': name of this module (package_name.module_name);
		'config_filename': name of the config file to load (<module_name>_config).
		"""
		# var_dict members should NOT be overridden
		if var_dict.has_key('relay_method'):
			self._relay = var_dict['relay_method']
		self.debug = var_dict['debug_method']
		self.log = var_dict['log_method']
		self.name = '%s.%s' % (var_dict['dotted_name'], self.__class__.__name__)
		try:
			self._load_config(var_dict['path'], var_dict['config_filename'])
		except ImportError, msg:
			self.debug(self, 'could not load config file [%s]' % msg, 2)
		except ValueError, msg:
			self.debug(self, 'no config file', 2)

	def _load_config(self, path, modulename):
		"""_load_config(path, modulename):
		import the specified module and set variables specified there
		as instance attributes.
		path: absolute path of directory containing the module to load;
		modulename: name of the module (no .py? suffix).
		"""
		import sys
		sys.path.insert(0, path) # patschert?
		del sys
		config = __import__(modulename)
		print dir(config)
		for key in config.vars.keys():
			setattr(self, key, config.vars[key])

##	def _relay(self, data):
##		self.debug(self, 'no relay method available')

	def receive(self, data_dict):
		"""receive(data_dict):
		called by the server's registry. should be overwritten in order
		for the plugin to access incoming data. this is your ear listening to co2.
		data_dict: relayed data in a dictionary.
		(return values are ignored.)
		NOTE: this method is called by a thread spawned by the satellite. so, while
		there is basically no need to override it with a threaded method, it is
		probably a good idea to do so in case processing done by your receive()
		takes a long time (longer than the intervall between incomming calls), which
		would result in many threads hanging around on the satellite side waiting
		for your method to return.
		"""
		self.debug(self, 'received: %s' % str(data_dict), 2)

	def send(self, data):
		"""send(data):
		send data to the relay. wraps the argument in a dictionary with key "data".
		data: any type that can be marshalled to xml.
		NOTE: the satellite's method, that is called in turn to actually send the
		request to the relay, is threaded. so, there's no need to call this method
		in a thread since it will return immediately.
		"""
		if type(data) != type({}):
			data = {'data':data}
		self._relay(data)

	def __exit__(self):
		"""__exit__():
		called by the satellite on exit. should be overwritten in case
		the plugin needs to clean up. the server waits until this method
		returns. (return values are ignored.)
		"""
		self.debug(self, 'exit hook called', 1)

	def __str__(self):
		"""__str__():
		returns: string representation of this instance (as it appears
		in the log etc). may be overridden.
		"""
		return '%s' % self.name
	__repr__ = __str__

if __name__ == '__main__':
	"""for testing"""
	def debug(caller, msg, level=0):
		print '%s: %s' % (str(caller), msg)
	p = Co2Plugin({'relay_method':'',
								 'debug_method':debug,
								 'log_method':'',
								 'dotted_name':'spam.eggs',
								 'path':'/home/lu/devel/co2/co2/plugins',
								 'config_filename':''})

