from string import join

class ProcessorError(Exception):
	pass

class Processor:
	def __init__(self):
		self.numbers = []
		self.strings = []

	def add_number(self, number):
		self.number.append(number)

	def add_string(self, str):
		self.strings.append(str)

	def process(self, object):
		if len(object) == 0:
			raise ProcessorError('empty dictionary')
		processor = self.get_processor(object)
		print 'processor:', processor.__name__
		processor(object)
		return join(self.numbers), join(self.strings)

	def process_dict(self, dict):
		for key in dict.keys():
			processor = self.get_processor(dict[key])
			print 'processor:', processor.__name__
			processor(dict[key])

	def process_sequence(self, seq):
		for item in seq:
			processor = self.get_processor(item)
			print 'processor:', processor.__name__
			processor(item)

	def process_number(self, num):
		self.numbers.append(str(num))

	def process_string(self, str):
		self.strings.append(str)

	def process_none(self, nix):
		return ''

	def get_processor(self, object):
		if type(object) == type(0) or type(object) == type(0.0):
			return self.process_number
		elif type(object) == type(''):
			return self.process_string
		elif type(object) == type([]) or type(object) == type(()):
			return self.process_sequence
		elif type(object) == type({}):
			return self.process_dict
		elif type(object) == None:
			return self.process_none

if __name__ == '__main__':
	input = ([[1, 2], 4, 6, 8])
	p = Processor()
	print str(p.process(input))
