from threading import Thread
from time import sleep

class Limiter(Thread):
	# TODO: these from config file
	max_q_len = 50
	iv = 0.1
	# rediculously low settings for testing
	#max_q_len = 2
	#iv = 1

	def init(self, method, debug_method):
		self.queue = []
		self.method = method
		self.debug = debug_method
		self.running = False

	def enqueue(self, data):
		if len(self.queue) < self.max_q_len:
			self.queue.append(data)
			#self.debug(self, 'enqueue: q = %s' % str(self.queue))
		else:
			self.debug(self, 'WARNING: queue full. %s dropped!' % str(data), 2)
			#self.debug(self, 'q = %s' % str(self.queue))

	def run(self):
		self.running = True
		self.debug(self, 'starting with max_q_len %d and iv %.2f' % (self.max_q_len,
																																 self.iv), 1)
		while self.running:
			if len(self.queue) > 0:
				self.pop()
			if not self.running: break
			sleep(self.iv)
		self.debug(self, 'exiting...', 1)

	def halt(self):
		self.debug(self, 'HALT', 0)
		self.running = False

	def pop(self):
		#self.debug(self, 'bfore pop: q = %s' % str(self.queue))
		data = self.queue.pop(0)
		self.method(data)
		if len(self.queue) == 0:
			self.debug(self, 'queue empty', 0)

	def __str__(self):
		return self.__class__.__name__

if __name__ == '__main__':
	def debug(caller, msg, level=0):
		print '%s: %s' % (caller, msg)
	def meth(data):
		debug('meth', str(data))
	l = Limiter()
	l.init(meth, debug)
	for key in range(0, 10):
		l.enqueue({str(key):key})
	l.start()
	sleep(2)
	for key in range(10, 15):
		l.enqueue({str(key):key})
	sleep(.2)
	for key in range(10, 15):
		l.enqueue({str(key):key})
	sleep(1)
	l.halt()
