"""html_factory:
very basic module to provide webbrowser access to the server's methods.
this still need _a lot_ of work!...
"""

from urllib import unquote
from xmlrpclib import DateTime

colors = {'blue':'#00b6ee',
					'orange':'#ee9b00'}

address = ('localhost', 2003)
registry_type = 'satellite'
method_table = ''

##head_xhtml = '''<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
##<html>
##<head>
##<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
##<title>co2</title>
##</head>
##<body>
##'''

head = '''<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">
<title>co2</title>
</head>
<body>
'''

##header_xhtml = '''<font face="sans-serif" size="4" color="#30d3e8">
##co2 %(registry)s @ %(host)s:%(port)d
##</font>
##<p />
##'''

header = '''<font face="sans-serif" size="4" color="#30d3e8">
co2 %(registry)s @ %(host)s:%(port)d
</font>
<p>
'''

message = '''<font face="sans-serif" size="3" color="#ff6d4c">
%s
</font>
'''

##foot_xhtml = '''<hr />
##<font face="sans-serif" size="2">
##- <a href="http://%(host)s:%(port)d">index</a> -
##</font>
##</body>\n</html>\n
##'''

foot = '''<hr>
<font face="sans-serif" size="2">
- <a href="http://%(host)s:%(port)d">index</a> -
</font>
</body>\n</html>\n
'''

##sat_link_xhtml = {'relay':'<a href="satellites?">satellites</a><p />',
##						'satellite':''}

sat_link = {'relay':'<a href="satellites?">satellites</a><p>',
						'satellite':''}

##index_xhtml = '''<font face="sans-serif" size="3">
##some explanations here...
##</font>
##<p />
##<a href="methods?">methods</a>
##<p />
##%(reg)s
##'''

index = '''<font face="sans-serif" size="3">
some explanations here...
</font>
<p>
<a href="methods?">methods</a>
<p>
%(reg)s
'''

def make_header():
	return header % {'registry':registry_type, 'host':address[0], 'port':address[1]}

def make_message(msg):
	return message % msg

def make_foot():
	return foot % {'host':address[0], 'port':address[1]}

def make_page(type='index', msg='', stuff=''):
	"""make_page(server_addr, msg=''):
	make an html page
	server_addr: tuple, the address of the server (used for index-link);
	msg: string, optional text message to insert at the top of the page
	(used for displaying replies and traces).
	returns: string, an html formatted page.
	"""
	if type == 'index':
		return '%s%s%s%s%s%s' % (head, make_header(), make_message(msg), stuff, index % {'reg':sat_link[registry_type]}, make_foot())
	elif type == 'methods':
		return '%s%s%s%s%s' % (head, make_header(), make_message(msg), method_table, make_foot())
	elif type == 'satellites':
		return '%s%s%s%s%s' % (head, make_header(), make_message(msg), stuff, make_foot())
	else:
		return '%s%s%s%s' % (head, make_header(), make_message(msg), make_foot())

def dict_to_table(prop_dict, caption=''):
	# TODO: sort keys
	html = '<table>\n'
	caption = prop_dict.pop(caption, '')
	if caption != '':
		html = '%s<tr><td colspan="2"><b>%s</b></td></tr>\n' % (html, caption)
	for key in prop_dict:
		html = '%s<tr><td><code>%s</code></td>' % (html, key)
		if type(prop_dict[key]) == type(''):
			val = prop_dict[key]
		elif type(prop_dict[key]) == type(0.0):
			val = '%.2f' % round(prop_dict[key], 2)
		elif isinstance(prop_dict[key], DateTime):
			d, t = str(prop_dict[key]).split('T')
			d = '%s.%s.%s' % (d[:4], d[4:6], d[6:8])
			val = '%s %s' % (d, t)
		else: val = str(prop_dict[key])
		html = '%s<td><code>%s</code></td></tr>\n' % (html, val)
	#return '%s</table><p />' % html # xhtml
	return '%s</table><p>' % html

def make_method_table(meth_dict):
	html = """
	<table width="100%" border="0" cellspacing="5">
	<tr><td colspan="2"><font size="3"><b>methods</b></font></td></tr>
	"""
	method_names = meth_dict.keys()
	method_names.sort()
	for method_name in method_names:
		html = """
%s<tr><td valign="top" bgcolor="%s"><font size="3">%s</font></td>
""" % (html, colors['blue'], method_name)
		html = """
%s<td align="right"><font size="2">signature:</font> <code>%s</code></td></tr>
""" % (html, meth_dict[method_name].signature)
		html = """
%s<tr><td colspan="2"><pre>%s</pre><br></td></tr>\n
""" % (html, escape(meth_dict[method_name].doc))
	return '%s</table>\n' % html

def escape(string):
	return string.replace('<', '&lt;').replace('>', '&gt;') #.replace(';', ';\n')

if __name__ == '__main__':
	"""for testing"""
	props = {'last_ping': '-1.00', 'recv_time': DateTime(), 'ctime': '20030920 21:09:19', 'failed_pings': 0, 'send_time': '20030920 21:09:19', 'host_id': '127.0.0.1:2004', 'addr': ('127.0.0.1', 2004)}
	print format_sat_props(props)
