################################################################
## config.py
## co2 configuration file
##
## !!!
## variables you _have_ to set according to your setup are:
## host and co2_home
## !!!
##
## variables you most probably want to set to your liking:
## plugin_list, background
##
## for the rest, the defaults should be ok


################################################################
## networking

# hostname or ip of this instance. CHANGE!
host = 'spam.shrubbery.org'

# port we listen on
port = 2003

# hostname or ip of the co2-relay. for satellites, you  must provide
# this, because one of the first things a satellite does, is register
# with relay which in turn allows it to communicate with the co2 network.
# unless you want to use your own relay (co2 network) use the main
# co2 relay co2.mur.at
relay_host = 'co2.mur.at'

# port the relay listens on. the default port for relay and satellites
# to listen on is 2003. co2.mur.at will always (well, almost...) be
# listening there.
relay_port = 2003

# socket timeout in secs. used for sending requests.
# (None defaults to 20.0)
socket_timeout = None


################################################################
## global

# fork to the background on startup
#background = True
background = False

# user the server should run as (numerical uid! None for no change)
# only works on *nix plattforms, and as root
#uid = 1002
uid = None

# the server's base directory. where you unpacked the archive.
# must be an absolute path. CHANGE!
co2_home = '/path/to/co2/'

# all paths below are relative to co2_home:

# where to write the PID (process ID).
# use to stop the server if running in the background
# (like: kill `cat pid`).
# all but the file part of the path must exist.
pid_file = 'pid'

# file to log to if backgrounded.
# xmlrpc calls and requests to the built in webinterface are logged
# here (apache-style).
# all but the file part of the path must exist.
log_file = 'logs/log'

#####################################################################
# debug_file is UNUSED yet! debug messages go to <log_file>
#
# file to write debug and info messages to if running in background.
debug_file = 'logs/debug'
#####################################################################

# 0, 1, 2 or 3 (debug, info, warn, error)
# 0 prints tons of stuff only interesting for debugging / development.
# 3 prints out only error messages. 2 seems a good choice for a stable
# server installation. will output/log error and warning messages.
debug_level = 2

# name of the directory containing the plugin packages.
# path relative to co2_home
plugin_dir = 'plugins'

# optional nickname for the server. will appear as a short hand name.
# only used for satellites.
# None defaults to the ID assigned by the relay at registration time.
#nick = None
nick = 'ni!'

# name of the person running this server
maintainer = 'The Dirty Vicar'

# maintainer's email address. this will be publicly available, so
# either modify your real address (like me_AT_there_DOT_net) or
# use a dummy.
maintainer_email = 'mail@thanks.no'

################################################################
## server settings

# whether or not requests are processed threaded
# unless you have a good reason you should leave this True!
threaded = True

# registry to use (one of 'satellite' or 'relay')
# a relay is s central co2 server through which satellites communicate.
# a satellite registers with a relay and then uses it to communicate with
# the co2 network (probably what you want).
registry = 'satellite'

# plugins to load on startup.
# [] for all available, i.e. all python packages in <plugin_dir>
# None for no plugins)
plugin_list = None
#plugin_list = ['pd']


################################################################
## other stuff


################################################################
## nothing to edit below

from os.path import join

# available registries
registries = ('relay', 'satellite')

global_vars = {'background':background,
							 'uid':uid,
							 'pid_file':pid_file,
							 'log_file':log_file,
							 'debug_file':debug_file,
							 'debug_level':debug_level}

server_vars = {'addr':(host, port),
							 'threaded':threaded,
							 'registry':registry}

registry_vars = {'addr':(host, port),
								 'relay_addr':(relay_host, relay_port),
								 'socket_timeout':socket_timeout,
								 'plugin_path':join(co2_home, plugin_dir),
								 'plugin_list':plugin_list,
								 'co2_home':co2_home,
								 'nick':nick,
								 'maintainer':maintainer,
								 'maintainer_email':maintainer_email}

del join
