"""client:
co2-specific wrapper around xmlrpclib.ServerProxy
"""

import xmlrpclib
from time import time

class Co2Proxy:
	"""'wrapper' around xmlrpclib.ServerProxy. outgoing xmlrpc
	messages originate here.
	"""
	def __init__(self, server_addr, socket_timeout=None, debugging=False):
		"""__init__(server_addr[, socket_timeout, debugging]):
		initialize a xmlrpclib.ServerProxy as self.proxy.
		server_addr: tuple (<host>, <port>);
		socket_timeout: socket timeout in seconds (if that is exceeded, a
		socket error is thrown), default if not set or None: 60.0;
		debugging: boolean, whether or not to print outgoing xmlrpc messages.
		"""
		if socket_timeout is not None:
			xmlrpclib.SOCKET_TIMEOUT = socket_timeout
		if not debugging:
			self.proxy = xmlrpclib.ServerProxy('http://%s:%d' % server_addr)
		else:
			self.proxy = xmlrpclib.ServerProxy('http://%s:%d' % server_addr, None, 'UTF-8', 1)

##	def __call__(self, prefix, method_name, *args, **kwargs):
##		pass

	def __str__(self):
		return '%s %s' % (self.__class__.__name__, self.proxy)
	__repr__ = __str__

def ping(addr):
	"""i guess this is unused..."""
	proxy = xmlrpclib.ServerProxy('http://%s:%d' % addr)
	t = time()
	proxy.ping({})
	return (time() - t) * 1000


if __name__ == '__main__':
	"""for testing:
	this can be used to test a co2 server (client or relay) running on
	the same machine.
	if you want to test relaying you MUST set host_id to a registered
	satellite's id. which, of course, requires that you first start a
	relay, then start a satellite, that connects to that relay and look
	up the id in the log or through either the relay's or the
	satellite's webinterface. you might call this 'spoofing' ;]
	(you could als register as a real satellite would do, and thus obtain
	a host_id to use, but then, since pings from the relay will not be
	answered, you will be kicked eventually.)
	also don't forget to set <address> to the address the server you
	want to connect to is listening on.
	then you can call any method of that server. the calls have to look
	something like:
	c.proxy.<method_name>([param_dict])
	where the optional argument <param_dict> is a dictionary as expected
	by the method. see the webinterface for method docs and signatures.
	the return values are not formatted in any way, just printed out.
	"""
	address = ('localhost', 2003)
	c = Co2Proxy(address)
	print 'client: %s' % c
	t1 = time()
	try:
		print 'ping:', ping(address)
		#print 'test:', c.proxy.test('BLAH!')
		host_id = c.proxy.relay.register({'port':2005,
																			'nick':'luC'})
		#host_id = '127.0.0.1:200'
		print 'host id:', host_id
		#print 'relay:', c.proxy.relay.relay({'host_id':host_id, 'data':2.3})
		print 'sys_props:', c.proxy.system.get_properties()
	except Exception, msg:
		print 'Error:', msg
	print 'time elapsed: %.2fms' % ((time() - t1)*1000,)

