"""checker
periodically ping registered satellites.
"""

from threading import Thread
from time import time, sleep

# TODO: these from config file:
max_failed_pings = 5 # after which we delete the satellite
tick = 1 # Checker frequency in secs
ping_iv = 60 # ping cycle in ticks

class Checker(Thread):
	"""Checker:
	pings all registered satellites and kicks them when they're unreachable
	for too long.
	"""

	def init(self, satellites, debug_method):
		"""init(satellites, debug_method):
		satellites: dictionary, registered satellites;
		debug_method: method object, the global debug method.
		"""
		self.satellites = satellites
		self.debug = debug_method

	def run(self):
		"""run():
		start the ping cycle.
		the thread will ping all registered satellites in turn, sleep for one
		tick (default 1s), then check if the halt method has been called, if
		so, exit the loop, otherwise sleep another tick etc.
		"""
		self.running = True
		count = 0
		while self.running:
			if (count % ping_iv) == 0:
				#self.debug(self, 'entering ping cycle')
				for host_id in self.satellites.keys():
					#self.ping(self.satellites[host_id])
					Thread(target = self.ping_thread,
								 args = (self.satellites[host_id],)).start()
			count += 1
		 	sleep(tick) # TODO: rather use abs time?
		self.debug(self, 'exiting...', 1)

	def ping_thread(self, sat):
		"""ping(sat):
		call a satellite proxy's ping method, calculate the delay, store it
		in the satellite's local representation and log the delay to the
		server's logfile.
		sat: Satellite instance, the satellite to ping.
		"""
		t = time()
		try:
			getattr(sat.proxy.proxy, 'ping')({})
			sat.set_ping_current((time() - t) * 1000)
			self.debug(self, 'ping "%s" [%.2fms]' % (sat.host_id,
																							 sat.ping_current),
								 1)
		except Exception, msg:
			#util.trace()
			failed_pings = sat.increment_ping_fails()
			self.debug(self, '%d. failed ping ("%s")' % (failed_pings,
																									 sat.host_id),
								 2)
			if failed_pings > max_failed_pings:
				del self.satellites[sat.host_id]
				self.debug(self, 'sat "%s" unreachable -> kicked' % sat.host_id, 2)

	def halt(self):
		"""halt():
		tells the ping cycle to end. called on exit.
		"""
		self.running = False
		self.debug(self, 'HALT', 0)

	def __str__(self):
		return self.__class__.__name__
	__repr__ = __str__

##if __name__ == '__main__':
##	def debug(caller, msg):
##		print '%s: %s' % (caller, msg)
##	class P:
##		def proxy(self):
##			return 'proxy'
##	class S:
##		host_id = 'ID'
##		proxy = P()
##		def get_latest_ping(self):
##			return 0.815
##		def increment_failed_pings(self):
##			return 1
##	s1 = S()
##	sats = {s1.host_id:s1}
##	c = Checker()
##	c.init(sats, debug)
##	c.start()
##	sleep(5)
##	c.halt()
