"""util:
miscellaneous co2 utilities
"""

from StringIO import StringIO
from traceback import print_exc
from os.path import join, isfile
from os import remove as os_remove

try:
	from xml.marshal import generic as maresciallo
	can_marshal = True
except:
	can_marshal = False

##class DumpError(Exception): pass

#print_trace = True

def trace(print_it=False):
	"""return or print a traceback after an exception occurred.

	@param print_it: whether to print the trace to stdout or to return it
	@type print_it: boolean
	@return: the trace if print_it is True, else None
	@rtype: string or None
	"""
	tb_string = StringIO()
	print_exc(file = tb_string)
	value = tb_string.getvalue()
	tb_string.close()
	if not print_it:
		return value
	limiter = 64 * '#'
	print '%s\n%s\n%s' % (limiter,
												value.replace('\n', '\n* '),
												limiter)

def dump_sat_data(sat_data, path, filename):
	"""convert data to xml and write it to a file. used by the relay to
	serialize satellite data.

	@param sat_data: object to be serialized
	@type sat_data: simple python object
	@param path: path of the dump file
	(directory containing the file, absolute path)
	@type path: string
	@param filename: name of the dumpfile
	@type filename: string
	"""
	f = None
	try:
		f = file(join(path, filename), 'w')
		maresciallo.dump(sat_data, f)
	finally:
		if f is not None: f.close()

def read_sat_data(path, filename):
	"""load an xml dumpfile (as created by dump_sat_data), and convert
	the data to a python object.

	@param path: path of the dump file
	(directory containing the file, absolute path)
	@type path: string
	@param filename: name of the dumpfile
	@type filename: string
	@return:
	@rtype: object
	"""
	f = None
	try:
		dump_file_name = join(path, filename)
		if not isfile(dump_file_name):
			return []
		f = file(dump_file_name, 'r')
		return maresciallo.load(f)
	finally:
		if f is not None: f.close()

def remove_file(path, filename):
	"""remove_file(path, filename):
	remove a file.
	@param path: absolute path a directory conteining the file
	@type path: string
	@param filename: name of the file do be removed
	@type filename: string
	
	@return: True on success, False on failure
	@rtype: boolean
	"""
	fn = join(path, filename)
	if isfile(fn):
		os_remove(fn)
		return True
	return False
