"""test_client:
'standalone' co2 client for testing and debugging.
"""

from client import Co2Proxy
from time import time

if __name__ == '__main__':
	"""for testing:
	this can be used to test a co2 server (client or relay) running on
	the same machine.
	if you want to test relaying you MUST set host_id to a registered
	satellite's id. which, of course, requires that you first start a
	relay, then start a satellite, that connects to that relay and look
	up the id in the log or through either the relay's or the
	satellite's webinterface. you might call this 'spoofing' ;]
	(you could als register as a real satellite would do, and thus obtain
	a host_id to use, but then, since pings from the relay will not be
	answered, you will be kicked eventually.)
	also don't forget to set <address> to the address the server you
	want to connect to is listening on.
	then you can call any method of that server. the calls have to look
	something like:
	c.proxy.<method_name>([param_dict])
	where the optional argument <param_dict> is a dictionary as expected
	by the method. see the webinterface for method docs and signatures.
	the return values are not formatted in any way, just printed out.
	"""
	address = ('co2.mur.at', 2003)
	c = Co2Proxy(address)
	print 'client: %s' % c
	t1 = time()
	try:
		print 'ping:', c.proxy.ping()
		print 'test:', c.proxy.test({'parrot':'dead...'})
		print 'sys_props:', c.proxy.system.get_properties()
	except Exception, msg:
		print 'Error:', msg
	print 'time elapsed: %.2fms' % ((time() - t1)*1000,)

