"""satellite:
the co2 registry with satellite functionality
"""

from xmlrpclib import Fault
from threading import Thread

import registry
#from limiter import Limiter

class Co2SatelliteRegistry(registry.Co2Registry):
	"""Co2SatelliteRegistry: provides the satellite specific methods.
	"""
	def __init__(self, vars):
		"""__init__(vars):
		first calls Co2Registry's __init__, then does some initial stuff
		for its own (register with the relay).
		@param vars: dictionary, registry specific variables.
		@type vars: dictionary.
		"""
		registry.Co2Registry.__init__(self, vars)
		self.notify_pass = str(id(self))
		# TODO: sollte nicht eher von aussen
		# registriert/subscribed werden (co2.py)?
		try:
			self.host_id = self._register()
		except Exception, msg:
			raise registry.Co2RegistryError(msg)
		self.debug(self, 'registered as %s' % self.host_id, 2)
		#raise registry.Co2RegistryError('AUSSI!')
		self.limiter.init(self._relay_real, self.debug)
		self.limiter.start()

	def _register(self):
		"""make a register call to the relay. returns a new host_id.

		@return: host id
		@rtype: string
		"""
		# exception handling is done in registry.Co2Registry
		plugin_list = self.vars['plugin_list'] or []
		return self._call_relay_thread('relay.register',
																	 {'port':self.vars['addr'][1],
																		'plugins':plugin_list or [],
																		'nick':self.vars['nick'],
																		'notify_pass':self.notify_pass})

	def _exit_hook(self):
		"""_exit_hook():
		clean up method, called by server on exit.
		"""
		# call registry's exit hook
		registry.Co2Registry._exit_hook(self)
		#self.limiter.halt()
		self.debug(self, 'deregistering...', 1)
		# deregister with the relay
		self.debug(self, self._call_relay('relay.deregister'), 0)
		self.debug(self, 'finished cleaning up.', 1)

	def _relay(self, data_dict):
		self.limiter.enqueue(data_dict)

	def _relay_real(self, data_dict):
		"""convenience method on top of _call_relay(). equivalent to
		_call_relay('relay.relay', data_dict).

		@param data_dict: data to be relayed.
		@type data_dict: dictionary.
		"""
		#return self._call_relay('relay.relay', data_dict)
		if not data_dict.has_key('data'):
			raise Co2RegistryError('no key "data" found. nothing to send...')
		return self._call_relay('relay.relay', data_dict)

	def _call_relay(self, method_name, param_dict={}):
		"""start a thread that calls method_name with argument param_dict
		on the relay .

		@param method_name: name of the method to be called.
		@type method_name: string.
		@param param_dict: optional parameter.
		@type param_dict: dictionary, default: {}.
		"""
		Thread(target = self._call_relay_thread, args = (method_name,
																										 param_dict)).start()
		return 'OK'

	def _call_relay_thread(self, method_name, param_dict):
		"""outgoing call to the relay. exceptions are cought and not passed
		on to the calling host, except when method_name is 'relay.register'
		a Co2RegistryError is raised, so that satellites can react,
		probably exit.

		@param method_name: name of the relay's method to be called.
		@type method_name: string.
		@param param_dict: argument to be passed to the method.
		@type param_dict: dictionary.
		"""
		#print 'REGISTRY _call_relay RAW:', method_name, param_dict
		param_dict['host_id'] = self.host_id# or 'unregistered@%s:%d' % self.vars['addr']
		#print 'REGISTRY _call_relay +ID:', method_name, param_dict
		try:
			self.debug(self,
								 'calling relay ["%s%s"]' % (method_name,
																						 str(param_dict)),
								 0)
			return getattr(self.relay_proxy.proxy, method_name)(param_dict)
		except Exception, msg:
			param_dict.pop('host_id')
			self.debug(self,
								 'call "%s(%s)" failed: %s' % (method_name,
																							 str(param_dict),
																							 msg),
								 3)
			if method_name == 'relay.register':
				self.debug(self, msg, 3)
				raise registry.Co2RegistryError('ERROR: unable to register.')

	def _notify_thread(self, recv_method, param_dict):
		"""call recv_method with param_dict as argument. called by
		L{registry.Co2Registry}'s x_top_notify method.

		@param recv_method: the method to call
		@type recv_method: method object
		@param param_dict: argument to recv_method
		@type param_dict: dictionary
		"""
		try:
			recv_method(param_dict)
		except KeyError, msg:
			self.debug(self,
								 'notify: malformed parameters [%s]' % param_dict,
								 2)
		except Exception, msg:
			self.debug(self,
								 'call to %s failed, args: %s [%s]' % (recv_method,
																											 param_dict,
																											 msg),
								 2)

	def _notify(self, recv_method, param_dict):
		"""call L{registry.Co2Registry}'s _notify_thread method in a thread.

		@param recv_method: the method to call
		@type recv_method: method object
		@param param_dict: argument to recv_method
		@type param_dict: dictionary
		"""
		Thread(target = self._notify_thread, args = (recv_method,
																								 param_dict)).start()

	def _check_notify(self, param_dict):
##		if param_dict['client_address'][0] not in self.vars['relay_hostnames'] or \
##			 not param_dict.has_key('notify_pass') or \
##			 param_dict['notify_pass'] != self.notify_pass:
##			#print param_dict['client_address'][0], '!=', self.vars['relay_hostnames']
##			self.debug(self, 'unauthorized notify call [%s]' % (param_dict), 2)
##			raise registry.Co2RegistryError('unauthorized')

		deny = False
		if param_dict['client_address'][0] not in self.vars['relay_hostnames']:
			deny = True
			msg = '%s not in known relay-names %s' % (param_dict['client_address'][0],
																								str(self.vars['relay_hostnames']))
		elif not param_dict.has_key('notify_pass'):
			deny = True
			msg = 'missing key "notify_pass" in call-data [%s]' % str(param_dict)
		elif param_dict['notify_pass'] != self.notify_pass:
			deny = True
			msg = 'invalid notify_pass [%s]' % param_dict['notify_pass']
		if deny:
			#print param_dict['client_address'][0], '!=', self.vars['relay_hostnames']
			self.debug(self, 'unauthorized notify call [%s]' % (param_dict), 2)
			raise registry.Co2RegistryError('unauthorized: %s' % msg)

	def x_top_notify(self, param_dict):
		"""distributes incoming calls to all plugins' receive methods.
		only 

		@param param_dict: data to be sent to plugins
		@type param_dict: dictionary
		@return: 'OK'
		@rtype: string

		exceptions thrown by a plugin's receive method are logged and
		ignored.

		callable as: notify
		"""
		self.debug(self, 'notify [%s]' % param_dict, 0)
		if self.vars['paranoid']:
			self._check_notify(param_dict)
##		if param_dict['client_address'][0] not in self.vars['relay_hostnames']:
##			#print param_dict['client_address'][0], '!=', self.vars['relay_hostnames']
##			self.debug(self, 'unauthorized notify call [%s]' % (param_dict), 2)
##			raise registry.Co2RegistryError('unauthorized')
##		else:
		for recv in self.receivers:
			self._notify(recv, param_dict)
		return 'OK'

##		for recv in self.receivers:
##			try:
##				self._notify(recv, param_dict)
##			except Exception, msg:
##				self.debug(self, 'ERROR:  [%s]' % str(msg), 3)
##				continue
##		return 'OK'
