from string import join

class ProcessorError(Exception):
	pass

class Processor_In:
	def __init__(self):
		pass

	def process(self, object):
		if len(object) == 0:
			raise ProcessorError('empty dictionary')
		processor = self.get_processor(object)
		#print 'processor:', processor.__name__
		numbers = []
		strings = []
		processor(object, numbers, strings)
		return join(numbers), join(strings)

	###############################
	# processors

	def process_dict(self, dict, numbers, strings):
		for key in dict.keys():
			processor = self.get_processor(key)
			#print 'processor:', processor.__name__
			processor(key, numbers, strings)
			processor = self.get_processor(dict[key])
			#print 'processor:', processor.__name__
			processor(dict[key], numbers, strings)

	def process_sequence(self, seq, numbers, strings):
		for item in seq:
			processor = self.get_processor(item)
			#print 'processor:', processor.__name__
			processor(item, numbers, strings)

	def process_number(self, num, numbers, strings):
		numbers.append(str(num))

	def process_string(self, str, numbers, strings):
		strings.append(str)

	def process_none(self, nix, numbers, strings):
		pass

	# /processors
	###############################

	def get_processor(self, object):
		if type(object) == type(0) or type(object) == type(0.0):
			return self.process_number
		elif type(object) == type(''):
			try:
				object = float(object)
				return self.process_number
			except ValueError:
				return self.process_string
		elif type(object) == type([]) or type(object) == type(()):
			return self.process_sequence
		elif type(object) == type({}):
			return self.process_dict
		#elif type(object) == None:
		else:
			return self.process_none

class Processor_Out:
	def process(self, str):
		data = []
		for atom in str.split():
			try:
				data.append(int(atom))
			except ValueError:
				try:
					data.append(float(atom))
				except ValueError:
					data.append(atom)
		return data

if __name__ == '__main__':
	p = Processor_In()
	input = ([[1, 2], 4, 6, 8])
	print p.process(input)
	input = ([{'blah':23.45}, .3, [{'spam':'ham', '42':'shrubbery', 'eggs':{'silly':'walk'}}, 47.11, .815], .816])
	print p.process(input)

	p = Processor_Out()
	input = ' 1 2 3 shrubbery .815'
	print str(p.process(input))
