import org.apache.xmlrpc.*;
import java.util.Vector;
import java.util.Hashtable;
import java.util.Enumeration;

public class Co2Test {
		public static String url;

		public Co2Test(String url) {
				this.url = url;
		}
		public static Object doit(String method_name, Hashtable param_table) {
				Object retval = new Object();
				Vector params = new Vector();
				params.add(param_table);
				try {
						XmlRpcClient proxy = new XmlRpcClient(url);
						retval = (Object) proxy.execute(method_name, params);
				}
				catch (XmlRpcException e) {
						System.err.println("JavaClient: XML-RPC Fault #" +
															 Integer.toString(e.code) + ":\n " +
															 e.toString());
				}
				catch (Exception ex) {
						System.err.println("JavaClient: " + ex.toString());
				}
				return retval;
		}
		public static void main(String[] args) {
				url = args[0];

				// get method list
				Object retval = doit("system.listMethods", new Hashtable());
				System.out.println("available methods:\n" + retval.toString());

				// get help and signature for each method
				Vector method_list = (Vector) retval;
				Hashtable param_table = new Hashtable();
				for (int i = 0; i < method_list.size(); i++) {
						String method_name = (String) method_list.get(i);
						param_table.put("method_name", method_name);
						// get method's help string
						retval = doit("system.methodHelp", param_table);
						System.out.println("\ndocstring for " + method_name + ":\n" + 
															 retval.toString());
						// get method's signature
						retval = doit("co2.get_method_signature", param_table);
						System.out.println("\nsignature for " + method_name + ":\n" + 
															 retval.toString());

						// clear the hashtable for next loop
						param_table.clear();
				}

				// get registered satellites
				//param_table.clear();
				retval = doit("co2.get_satellites", param_table);
				System.out.println("\ncurrently registered satellites:\n" + retval.toString());

				// get info about the sats
				Vector sat_id_list = (Vector) retval;
				for (int i = 0; i < sat_id_list.size(); i++) {
						String host_id = (String) sat_id_list.get(i);
						param_table.put("host_id", host_id);
						retval = doit("co2.get_satellite_props", param_table);
						System.out.println("\nsatellite " + host_id + ":");
						Hashtable props = (Hashtable) retval;
						for (Enumeration e = props.keys() ; e.hasMoreElements() ;) {
								String key = (String) e.nextElement();
								System.out.println(key + ": " + props.get(key));
						}
				}
		}
}
