"""html_factory:
very basic module to provide webbrowser access to the server's methods.
this still needs _a lot_ of work!...
"""

from urllib import unquote
from xmlrpclib import DateTime

colors = {'blue':'#00b6ee',
					'orange':'#ee9b00'}

address = ('localhost', 2003)
registry_type = 'satellite'
method_table = ''


# switched back to html for java browser compatibility (pfffff...)

##head_xhtml = '''<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
##<html>
##<head>
##<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
##<title>co2</title>
##</head>
##<body>
##'''

head = '''<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">
<title>co2</title>
</head>
<body>
'''

##header_xhtml = '''<font face="sans-serif" size="4" color="#30d3e8">
##co2 %(registry)s @ %(host)s:%(port)d
##</font>
##<p />
##'''

header = '''<font face="sans-serif" size="4" color="#30d3e8">
co2 %(registry)s @ %(host)s:%(port)d
</font>
<p>
'''

message = '''<font face="sans-serif" size="3" color="#ff6d4c">
%s
</font>
'''

##foot_xhtml = '''<hr />
##<font face="sans-serif" size="2">
##- <a href="http://%(host)s:%(port)d">index</a> -
##</font>
##</body>\n</html>\n
##'''

foot = '''<hr>
<font face="sans-serif" size="2">
- <a href="http://%(host)s:%(port)d">index</a> -
</font>
</body>\n</html>\n
'''

##sat_link_xhtml = {'relay':'<a href="satellites?">satellites</a><p />',
##						'satellite':''}

sat_link = {'relay':'<font face="sans-serif" size="2"><a href="satellites?">satellites</a> - satellites currently registered with this relay.</font><p>',
						'satellite':''}

##index_xhtml = '''<font face="sans-serif" size="3">
##some explanations here...
##</font>
##<p />
##<a href="methods?">methods</a>
##<p />
##%(reg)s
##'''

index = """<br><br><font face="sans-serif" size="2">
<a href="methods?">methods</a> - this server's xmlrpc methods. with descriptions and usage information.<br><br>
</font>
<p>
%(reg)s
"""

def make_header():
	"""make an html header (page caption).

	@return: html formatted header
	@rtype: string
	"""
	return header % {'registry':registry_type, 'host':address[0], 'port':address[1]}

def make_message(msg):
	"""format a message to be displayed on top of the page.

	@param msg: the message to display
	@type msg: string
	@return: html formatted message
	@rtype: string
	"""
	return message % msg

def make_foot():
	"""make an html footer (html closing tags, index link).

	@return: html formatted footer
	@rtype: string
	"""
	return foot % {'host':address[0], 'port':address[1]}

def make_page(type='index', msg='', stuff=''):
	"""make an html page.

	@param type: page type
	@type type: string
	@param msg: optional text message to insert at the top of the page (used
	for displaying replies and traces)
	@type msg: string
	@param stuff: additional stuff to print
	@type stuff: string
	@return: an html formatted page
	@rtype: string
	"""
	if type == 'index':
		return '%s%s%s%s%s%s' % (head, make_header(), make_message(msg), stuff, index % {'reg':sat_link[registry_type]}, make_foot())
	elif type == 'methods':
		return '%s%s%s%s%s' % (head, make_header(), make_message(msg), method_table, make_foot())
	elif type == 'satellites':
		return '%s%s%s%s%s' % (head, make_header(), make_message(msg), stuff, make_foot())
	else:
		return '%s%s%s%s' % (head, make_header(), make_message(msg), make_foot())

def dict_to_table(dict, caption=''):
	"""format a dictionary into an html table.

	@param dict: data
	@type dict: dictionary
	@return: html formatted dictionary data
	@rtype: string
	"""
	# TODO: sort keys
	html = '<table>\n'
	caption = dict.pop(caption, '')
	if caption != '':
		html = '%s<tr><td colspan="2"><b>%s</b></td></tr>\n' % (html, caption)
	for key in dict:
		html = '%s<tr><td><code>%s</code></td>' % (html, key)
		if type(dict[key]) == type(''):
			val = dict[key]
		elif type(dict[key]) == type(0.0):
			val = '%.2f' % round(dict[key], 2)
		elif isinstance(dict[key], DateTime):
			d, t = str(dict[key]).split('T')
			d = '%s.%s.%s' % (d[:4], d[4:6], d[6:8])
			val = '%s %s' % (d, t)
		else: val = str(dict[key])
		html = '%s<td><code>%s</code></td></tr>\n' % (html, val)
	#return '%s</table><p />' % html # xhtml
	return '%s</table><p>' % html

def make_method_table(meth_dict):
	"""format the callable methods of a L{registry.Co2Registry} into an
	html table.

	@param meth_dict: method data
	(the registry's instance variable 'methods')
	@type meth_dict: dictionary
	@return: html table
	@rtype: string
	"""

	md = meth_dict.copy()
	method_names = md.keys()
	method_names.sort()
	unique_method_basenames = []
	for m_name in method_names:
		try:
			prefix, base_name = m_name.split('.')
			if base_name in unique_method_basenames or prefix == 'system':
				md.pop(m_name)
			else:
				unique_method_basenames.append(base_name)
		except ValueError:
			if m_name in unique_method_basenames:
				md.pop(m_name)
			else:
				unique_method_basenames.append(m_name)

	html = """<table width="100%" border="0" cellspacing="5">
 <tr>
  <td>
	 <font size="2" face="sans-serif">
	  <b>callable methods</b><br><br>
		methods prefixed with <code>web.</code> are accessible through
		HTTP GET requests. all others are for XMLRPC access only.<br>
		methods prefixed with <code>relay.</code> are for use by
		registered satellites use only.
   </font>
  </td>
 </tr>
"""
	method_names = md.keys()
	method_names.sort()
	for method_name in method_names:
		sig = md[method_name].signature

		html = """%s<tr>
 <td valign="top" bgcolor="%s">
  <font face="sans-serif" size="3">
   <b>%s</b>
  </font>
  <font face="serif" size="2">
   - arguments: %s, default arguments: %s
  </font>
 </td>
""" % (html, colors['blue'], method_name, sig['args'], sig['args_d'])

		html = """%s<tr>
 <td>
  <font face="sans-serif" size="2">
	 %s
	</font><br>
 </td>
</tr>
""" % (html, translate(meth_dict[method_name].doc))

		#sig = meth_dict[method_name].signature
		#html = """%s<td align="right"><font face="serif" size="2">arguments: %s, default arguments: %s</font></td></tr>""" % (html, sig['args'], sig['args_d'])
		#html = """%s<tr><td colspan="2"><font face="sans-serif" size="2">%s</font><br></td></tr>\n""" % (html, translate(meth_dict[method_name].doc))
	return '%s</table>\n' % html

def translate(str):
	"""very rudimentary escape for html entities.

	@param str: input to be made html-safe
	@type str: string
	@return: input with special characters replaced by html entities
	@rtype: string
	"""
	str = str.replace('<', '&lt;').replace('>', '&gt;')
	str = str.replace('\n', '<br>').replace('\t', '&nbsp;&nbsp;')
	str = str.replace('@param','<code>argument</code>')
	str = str.replace('@type', '<code>argument type</code>')
	str = str.replace('@return:', '<code>returns:</code>')
	str = str.replace('@rtype:', '<code>return type:</code>')
	str = str.replace('@raise', '<code>raises</code>')
	str = str.replace('callable as:', '<code>callable as:</code>')
	return str

if __name__ == '__main__':
	"""for testing"""
	props = {'last_ping': '-1.00', 'recv_time': DateTime(), 'ctime': '20030920 21:09:19', 'failed_pings': 0, 'send_time': '20030920 21:09:19', 'host_id': '127.0.0.1:2004', 'addr': ('127.0.0.1', 2004)}
	print format_sat_props(props)
