################################################################
## config.py
## co2 configuration file
##
## !!!
## variables you _have_ to set according to your setup are:
## host and co2_home
## !!!
##
## variables you most probably want to set to your liking:
## plugin_list, background
##
## for the rest, the defaults should be ok


################################################################
## networking

# hostname or ip of this instance. CHANGE!
host = 'spam.shrubbery.org'

# port we listen on
port = 2003

# hostname or ip of the co2-relay. for satellites, you  must provide
# this, because one of the first things a satellite does, is register
# with relay which in turn allows it to communicate with the co2 network.
# unless you want to use your own relay (co2 network) use the main
# co2 relay co2.mur.at
relay_host = 'co2.mur.at'

# port the relay listens on. the default port for relay and satellites
# to listen on is 2003. co2.mur.at will always (well, almost...) be
# listening there.
relay_port = 2003

# socket timeout in secs. used for sending requests.
# (None defaults to 20.0)
socket_timeout = None


################################################################
## global

# fork to the background on startup
#background = True
background = False

# user the server should run as (numerical uid! None for no change)
# only works on *nix plattforms, and as root
#uid = 1002
uid = None

# the server's base directory. where you unpacked the archive.
# must be an absolute path. CHANGE!
co2_home = '/path/to/co2/'

# all paths below are relative to co2_home:
# (remember to use different config files with different filenames
# if you run more than one server out of the same co2_home!
# otherwise all messages will be logged to one file and the pid file
# will only contain the pid of the most recently started instance.

# where to write the PID (process ID).
# use it to stop a backgrounded server (like: kill `cat pid`).
# all but the file part of the path must exist. if the file exists
# it will be overwritten.
pid_file = 'pid'

# file to log to if backgrounded.
# xmlrpc calls and requests to the built in webinterface are logged
# here (apache-style).
# all but the file part of the path must exist. if the file exists
# messages will be appended.
log_file = 'logs/log'

#####################################################################
# debug_file is UNUSED! (silly me, simply can't get this working...)
# debug messages go to <log_file>
#
# file to write debug and info messages to if running in background.
debug_file = 'logs/debug'
#####################################################################

# 0, 1, 2 or 3 (debug, info, warn, error)
# 0 prints tons of stuff only interesting for debugging / development.
# 3 prints out only error messages. 2 seems a good choice for a stable
# server installation. will output/log error and warning messages.
# note: this is the reverse of what you probably are used to!
debug_level = 2

# name of the directory containing the plugin packages.
# path relative to co2_home
plugin_dir = 'plugins'

# optional nickname for the server. will appear as a short hand name.
# only used for satellites.
# None defaults to the ID assigned by the relay at registration time.
#nick = None
nick = 'ni!'

# name of the person running this server
maintainer = 'The Dirty Vicar'

# maintainer's email address. this will be publicly available, so
# either modify your real address (like me_AT_there_DOT_net) or
# use a dummy.
maintainer_email = 'mail@thanks.no'


################################################################
## server settings

# whether or not requests are processed threaded.
# unless you have a good reason this should be set to True!
threaded = True

# registry to use (one of 'satellite' or 'relay')
# a relay is s central co2 server through which satellites communicate.
# a satellite registers with a relay and then uses it to communicate with
# the co2 network (probably what you want).
registry = 'satellite'

# maximum number of satellites we allow to be registered.
# has no effect if registry is 'satellite'.
max_sats = 12

# initial ping delay. when a satellite registers it will be ping'd
# after this many seconds. 1 should be enough, even for pretty lame
# satellite hosts, i guess. defaults to 1 if not set.
# has no effect if registry is 'satellite'.
init_ping_delay = 1

# plugins to load on startup.
# list of strings, example: ['spam', 'ham', 'eggs']
# [] for all available, i.e. all python packages in <plugin_dir>
# None for no plugins)
plugin_list = None
#plugin_list = ['pd']

# for satellites only:
# when receiving a notify call the registry checks whether the
# request's client_address matches the host_id (the original
# sender's co2 id which is automatically included in every
# relayed call). you will need to set this to False if your
# satellite's IP is masqueraded.
paranoid = True


################################################################
## nothing to edit below

from os.path import join

# available registries
registries = ('relay', 'satellite')

# this is UGLY! clean up!
global_vars = {'background':background,
							 'uid':uid,
							 'pid_file':pid_file,
							 'log_file':log_file,
							 'debug_file':debug_file,
							 'debug_level':debug_level}

server_vars = {'addr':(host, port),
							 'threaded':threaded,
							 'registry':registry}

registry_vars = {'addr':(host, port),
								 'relay_addr':(relay_host, relay_port),
								 'paranoid':paranoid,
								 'max_sats':max_sats,
								 'socket_timeout':socket_timeout,
								 'plugin_path':join(co2_home, plugin_dir),
								 'plugin_list':plugin_list,
								 'co2_home':co2_home,
								 'nick':nick,
								 'maintainer':maintainer,
								 'maintainer_email':maintainer_email,
								 'init_ping_delay':init_ping_delay}

del join
