"""client:
co2-specific wrapper around xmlrpclib.ServerProxy
"""

import xmlrpclib
from time import time

class Co2Proxy:
	"""'wrapper' around xmlrpclib.ServerProxy. outgoing xmlrpc messages
	originate here.
	"""
	def __init__(self, server_addr, socket_timeout=None, debugging=False):
		"""initialize an L{xmlrpclib.ServerProxy} as self.proxy.

		@param server_addr: address of the xmlrpc server
		@type server_addr: tuple (<host>, <port>)
		@param socket_timeout: socket timeout in seconds (if that is exceeded,
		a socket error is thrown), default if not set or None: 60.0
		@type socket_timeout: int
		@param debugging: whether or not to print outgoing xmlrpc messages
		@type debugging: boolean
		"""
		if socket_timeout is not None:
			xmlrpclib.SOCKET_TIMEOUT = socket_timeout
		if not debugging:
			self.proxy = xmlrpclib.ServerProxy('http://%s:%d' % server_addr)
		else:
			self.proxy = xmlrpclib.ServerProxy('http://%s:%d' % server_addr,
																				 None,
																				 'UTF-8',
																				 True)

##	def __call__(self, prefix, method_name, *args, **kwargs):
##		pass

	def __str__(self):
		return '%s %s' % (self.__class__.__name__, self.proxy)
	__repr__ = __str__

def ping(addr):
	"""i guess this is unused..."""
	proxy = xmlrpclib.ServerProxy('http://%s:%d' % addr)
	t = time()
	proxy.ping({})
	return (time() - t) * 1000
